/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: CifXDeviceSys.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 23.04.07 16:19 $
    $Revision: 3160 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    System device class, derived from CCifXDeviceBase to handle a system channel connection
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        28.06.2006  MT       initial version
 
**************************************************************************************/

#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifXDeviceSys.h
///   System device class, derived from CCifXDeviceBase to handle a system channel connection
///////////////////////////////////////////////////////////////////////////////////////////

#include "cifxdevicebase.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// System device class
///////////////////////////////////////////////////////////////////////////////////////////
class CCifXDeviceSys : public CCifXDeviceBase
{
public:
  CCifXDeviceSys(BOARD_INFORMATION* ptBoardInfo, CHANNEL_INFORMATION* ptChannelInfo);
  virtual ~CCifXDeviceSys(void);

  virtual bool                             IsSystemDevice(void);
  virtual int32_t                          OpenDevice(void);
  virtual int32_t                          CloseDevice(void);
  virtual int32_t                          PutPacket(CIFX_PACKET* ptPacket, uint32_t ulTimeout);
  virtual int32_t                          GetPacket(CIFX_PACKET* ptPacket, uint32_t ulBufferSize, uint32_t ulTimeout);
  virtual CCifXDeviceBase::PROPERTY_VECTOR GetChannelInformation(uint32_t ulCmd);
  virtual CString                          GetChannelInfoName(void);
  virtual int32_t                          GetMBXState(uint32_t* pulRecvCount, uint32_t* pulSendCount);
  virtual int32_t                          Reset(uint32_t ulMode, uint32_t ulTimeout);
  virtual int32_t                          Upload(char* szFilename, uint32_t ulChannel, unsigned char* pbBuffer, uint32_t* pulFileSize);
  
  virtual int32_t Download(uint32_t ulChannel, uint32_t ulMode, char* szFileName, 
                        unsigned char* pabFileData, uint32_t ulFileSize, 
                        PFN_PROGRESS_CALLBACK pfnCallback, void* pvUser);

  virtual int32_t FindFirstFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);
  virtual int32_t FindNextFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);

  virtual int32_t ExtendedMemoryMap(void);
  virtual int32_t ExtendedMemoryRelease(void);
  virtual int32_t ExtendedMemoryInfo(uint32_t& ulSize, uint32_t& ulType);
  virtual void*   ExtendedMemoryPointer(uint32_t* pulExtMemSize);

/////////////////////////////////////////////////////////////////////////////
  /// Overridden function for channel number. The System device does not own one, so return 0
  ///   \return 0
  /////////////////////////////////////////////////////////////////////////////
  virtual uint32_t GetChannelNr(void) { return 0; }
  virtual uint32_t GetMailboxSize(void);

protected:
  HANDLE m_hSysChannel;   //!< cifX driver Handle to the system channel

  CIFX_EXTENDED_MEMORY_INFORMATION  m_tMappedExtMem;

  int32_t GetSystemInfoBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemInformation(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemChannelBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemControlBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemStatusBlock(PROPERTY_VECTOR& cvRet);

};
